﻿Public Class Particle

    Public Position As Vector2
    Public Velocity As Vector2
    Public Acceleration As Vector2

    Public Property LifeTime As Single
    Public Property TimeSinceStart As Single
    Public Property Scale As Single
    Public Property Rotation As Single
    Public Property RotationSpeed As Single
    Public World As VirtualWorld

    Public ReadOnly Property IsActive As Boolean
        Get
            Return Me.TimeSinceStart < Me.LifeTime
        End Get
    End Property

    Sub New(world As VirtualWorld)
        Me.World = world
    End Sub

    Sub Initialize(position As Vector2, velocity As Vector2, acceleration As Vector2, lifetime As Single, scale As Single, rotationSpeed As Single, pSystem As ParticleSystem)
        Me.Position = Position
        Me.Velocity = Velocity
        Me.Acceleration = Acceleration
        Me.LifeTime = LifeTime
        Me.Scale = Scale
        Me.RotationSpeed = RotationSpeed
        Me.TimeSinceStart = 0.0F
        Me.Rotation = Me.World.RandomBetween(0, MathHelper.TwoPi)
    End Sub

    Public Sub Update(dt As Single)
        Me.Velocity += Me.Acceleration * dt
        Me.Position += Velocity * dt
        Me.Rotation = Me.RotationSpeed * dt
        Me.TimeSinceStart += dt
    End Sub




End Class
